/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.FrameworkResponse;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import com.mrcrayfish.framework.network.FrameworkCodecs;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;

public record S2CSyncedEntityData(Map<class_2960, List<Pair<class_2960, Integer>>> keyMap) {
    public static final class_9139<class_2540, S2CSyncedEntityData> STREAM_CODEC = class_9139.method_56434(FrameworkCodecs.ENTITY_DATA_KEYS, S2CSyncedEntityData::keyMap, S2CSyncedEntityData::new);

    public static FrameworkResponse handle(S2CSyncedEntityData message, Consumer<Runnable> executor) {
        Constants.LOG.debug(ConfigurationMessage.MARKER, "Received synced key mappings from server");
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        executor.accept(() -> {
            if (!SyncedEntityData.instance().updateMappings(message)) {
                failed[0] = true;
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (failed[0]) {
            return FrameworkResponse.error("[Framework] Received unknown synced data keys. See logs for more details.");
        }
        return FrameworkResponse.SUCCESS;
    }

    public Map<class_2960, List<Pair<class_2960, Integer>>> getKeyMap() {
        return this.keyMap;
    }
}

